﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Maps.MapControl;
using Microsoft.Maps.MapControl.Core;



namespace MapModes
{
    public partial class MainPage : UserControl
    {
        public MainPage()
        {
            InitializeComponent();
            //BaseMap();

            // Sets the map to the custom map mode.
            MapCustomMode.Mode = new CologneMapMode();
        }

        void BaseMap()
        {
            //Change the map mode to the base Mercator mode
            MapCustomMode.Mode = new MercatorMode();
            //MapCustomMode.Mode = new RoadMode();
            //MapCustomMode.Mode = new AerialMode();
            MapCustomMode.SetView(new Location(47.606115, -122.324495), 15);

            //Add new MapLayer containing the shape 
            MapLayer newLayer = new MapLayer();
            MapPolygon poly = new MapPolygon();

            //Define the polygon vertices
            LocationCollection boundingLocations = new LocationCollection();
            boundingLocations.Add(new Location(47.605, -122.323));
            boundingLocations.Add(new Location(47.607, -122.323));
            boundingLocations.Add(new Location(47.606115, -122.325));

            //Set the polygon properties
            poly.Locations = boundingLocations;
            poly.Fill = new SolidColorBrush(Colors.Green);
            poly.Stroke = new SolidColorBrush(Colors.Blue);
            poly.StrokeThickness = 4;
            newLayer.Children.Add(poly);

            //Add the layer containing the polygon to the map
            MapCustomMode.Children.Add(newLayer);
        }
    }
}
